# EMNIST Results
To reproduce the results given in the paper proceed as follows:

1. Install the requirements listed in [requirements.txt](requirements.txt) by running `pip install -r requirements.txt`.

2. (Optional) Change the code in [run.py](run.py) to iterate over sizes or activation functions and run it.

3. Use [stats_activations.py](stats_activations.py) to reproduce Table 11 from the paper.

## Copyright Notice
To allow a fair comparison with proxies from the literature, we use code from previous publications. 
The adaptations made are for the sole purpose of integrating the code into our software.
Please note the copyright and license at the top of each file.

* [fisher.py](proxies/fisher.py), [grad_norm.py](proxies/grad_norm.py), [grasp.py](proxies/grasp.py), 
[snip.py](proxies/snip.py), [synflow.py](proxies/synflow.py) are adapted from Ref. 1
and licensed under the Apache License, Version 2.0
* [meco.py](proxies/meco.py) is adapted from Ref. 2 and licensed under the MIT license
* [zen.py](proxies/zen.py) is adapted from Ref. 3 and licensed under the Apache License, Version 2.0
* [zico.py](proxies/zico.py) is adapted from Ref. 4 and licensed under the Apache License, Version 2.0


[1] M. S. Abdelfattah, A. Mehrotra, Ł. Dudziak, and N. D. Lane, 
    Zero-cost proxies for lightweight NAS, 
    in 9th International Conference on Learning Representations (ICLR) (2021).

[2] T. Jiang, H. Wang, and R. Bie, 
    MeCo: Zero-shot NAS with one data and single forward pass via minimum eigenvalue of correlation, 
    in Adv. Neural Inf. Process. Syst., Vol. 36 (2023) pp. 61020–61047.

[3] M. Lin, P. Wang, Z. Sun, H. Chen, X. Sun, Q. Qian, H. Li, and R. Jin, 
    Zen-NAS: A zero-shot NAS for high-performance image recognition, 
    in Proc. IEEE Int. Conf. Comput. Vis. (2021) pp. 347–356.

[4] G. Li, Y. Yang, K. Bhardwaj, and R. Marculescu, 
    ZiCo: Zero-shot NAS via inverse coefficient of variation on gradients, 
    in 11th International Conference on Learning Representations (ICLR) (Kigali, Rwanda, 2023).
