#!/usr/bin/env python3
import subprocess

activation_functions = ["SiLU", "ReLU", "Tanh", "Tanhshrink"]
weight_init = ["xavier", "default", "uniform"]

for seed in range(1234, 1255):
    for fct in activation_functions:
        for init in weight_init:
            cmd = f"python3 -u emnist_fnn.py --activation_function={fct} --weight_initialization={init} --seed={seed} --n_neurons 784 200 200 47"
            with open(f"{fct}_{init}_{seed}.out", "w") as file:
                output = subprocess.run(cmd, stdout=file, shell=True)

