#!/usr/bin/env python3
import re
import numpy as np
import math

sizes = [f"784_{size}_200_47" for size in range(120, 300, 20)]
sizes.extend([f"784_200_{size}_47" for size in range(40, 400, 40)])
sizes.append(f"784_1000_1000_47")

seeds = range(1234, 1244)
data = {}

for size in sizes:
    data[size] = {}
    for seed in seeds:
        data[size][seed] = {"test_loss": None, "test_accuracy": None}
        with open(f"results/size/results/{size}_{seed}.out", "r") as file:
            for line in file:
                if line.startswith("Test accuracy"):
                    line_split = re.findall(r"(?: )(\d+.\d+)", line)
                    data[size][seed]["test_accuracy"] = float(line_split[0])
                    data[size][seed]["test_loss"] = float(line_split[1])
                    break

def round_up(number, decimals=0):
    factor = 10 ** decimals
    return math.ceil(number * factor) / factor

row_format_body = "{:<25}" + "{:>20}" * 3
print(row_format_body.format("Layer sizes", "Test Accuracy", "Test Loss", "#Param"))
for size in sizes:
    loss = np.array([data[size][seed]["test_loss"] for seed in seeds])
    accuracy = np.array([data[size][seed]["test_accuracy"] for seed in seeds])
    tmp = [int(x) for x in size.split("_")]
    num_param = (tmp[0]+1)*tmp[1] + (tmp[1]+1)*tmp[2] + (tmp[2]+1)*tmp[3]
    print(row_format_body.format(
            f"{size.replace('_', ', ')}", 
            f"{np.mean(accuracy):.2f} ± {np.std(accuracy):.2f}", 
            f"{np.mean(loss):.3f} ± {round_up(np.std(loss), 3)}",
            f"{num_param:,}"
        )
    )
