#!/usr/bin/env python3
import subprocess
import signal
import os

sizes = [10, 20, 40, 80, 160, 320, 640, 1280]
for seed in range(1234, 1244):
    for size in sizes:
        subprocess.Popen(["python3", "-u", "input_lmlp.py", "--activation_function=sTanh", "--weight_initialization=sTanh", f"--seed={seed}", "--n_neurons_hidden_layers", "52", "54", f"{size}"],
            stdin=subprocess.DEVNULL,
            stdout=open(f"52_54_{size}_{seed}.out", "w", encoding="utf8"),
            stderr=subprocess.STDOUT,
            start_new_session=True,
            preexec_fn=(lambda: signal.signal(signal.SIGHUP, signal.SIG_IGN)),
            env=dict(os.environ) | {"PYTORCH_JIT": "0"}
    )
