## The Official code base for PhyloVAE
### Before training
Before starting your training, the training dataset should be constructed by running the command
```
python -c '''
from datasets import process_data; process_data($DATASET, $REP_ID);
'''
```
and the ground truth should be constructed by running the command
```
python -c '''
from datasets import process_empFreq; process_empFreq($DATASET, $REP_ID);
'''
```

### Training
To reproduce the result on the DS1-8 benchmarks, please run the following command
```
python main.py data.dataset=$DATASET data.rep_id=$REP_ID decoder.num_layers=4
```


### References
When building this codebase for PhyloVAE, we refer to codes of the following two articles.
- Zhang C. *Learnable Topological Features For Phylogenetic Inference via Graph Neural Networks*. ICLR 2023.
- Zhou M Y, Yan Z, Layne E, et al. *PhyloGFN: Phylogenetic inference with generative flow networks*. ICLR 2024.