#! /bin/sh
#
# init.sh
#
python3 -m venv ood_new
source ood_new/bin/activate 

# Install pytorch for cuda 10.2
pip3 install torch torchvision torchaudio
pip install torch_scatter -f https://pytorch-geometric.com/whl/torch-1.8.0+cu102.html

pip install jsonlines
pip install matplotlib
pip install gdown
#pip install scikit-learn==0.23.0
pip3 install -U scikit-learn
pip install pandas
pip install wilds --no-dependencies --upgrade
pip install submitit

# Dependencies for DIB
pip install -U skorch
#pip install --user --upgrade scipy=1.5.2
#pip install joblib

git submodule add git@github.com:facebookresearch/DomainBed.git
cd DomainBed
git checkout 61d3a83e3bc95cc939f1e6701f499d43edea7633
cd ..

git submodule add git@github.com:fairinternal/Decodable_Information_Bottleneck.git

mkdir "data"
cd DomainBed
python -m domainbed.scripts.download --data_dir="../data"
cd ..

export PYTHONPATH="${PYTHONPATH}:${PWD}/DomainBed/"
