
## Baseline model training and eval

```bash
# train
python faug/main.py -a gpu -n 4 -b 256 -w 16 -m 300

# eval
python faug/main.py -a gpu -n 4 -b 256 -w 16 -m 300 --resume ./lightning_logs/version_9 --eval
# 'test_acc': 0.9336000084877014, 'test_loss': 0.44612830877304077
```

## Simple feature augmentation strategy

```bash
CUDA_VISIBLE_DEVICES=0,1 python faug/main.py -a gpu -n 2 -b 256 -w 16 -m 300 --feature_aug cifar10_post_conv_simple --dir_path cifar10_post_conv_simple --model resnet50_aug --eval --resume ./cifar10_post_conv_simple/best.ckpt
# {'test_acc': 0.9329000115394592, 'test_loss': 0.4409644901752472}

CUDA_VISIBLE_DEVICES=2,3 python faug/main.py -a gpu -n 2 -b 256 -w 16 -m 300 --feature_aug cifar10_post_conv_layer_1_simple --dir_path cifar10_post_conv_layer1_simple --model resnet50_aug --eval --resume cifar10_post_conv_layer1_simple/best.ckpt
# {'test_acc': 0.9340000152587891, 'test_loss': 0.4819624125957489}
```

## Complex feature augmentation strategy

```bash
CUDA_VISIBLE_DEVICES=0,1 python faug/main.py -a gpu -n 2 -b 256 -w 16 -m 300 --feature_aug cifar10_all_complex --dir_path ./lightning_logs/cifar10_all_complex
# {'test_acc': 0.9380999803543091, 'test_loss': 0.4296708106994629}
CUDA_VISIBLE_DEVICES=2,3 python faug/main.py -a gpu -n 2 -b 256 -w 16 -m 300 --feature_aug cifar10_post_conv_complex --resume lightning_logs/cifar10_post_conv_complex/best.ckpt --eval
# {'test_acc': 0.9376999735832214, 'test_loss': 0.404556006193161}
```

## Cifar10

```
# pretrain
CUDA_VISIBLE_DEVICES=0,1,2,3 python faug/main.py -a gpu -n 4 -b 256 -w 16 -m 200 --save resnet50-pretrain-sgd --model resnet50 --dataset cifar10 --lr 0.2 --optimizer sgd --eval --load resnet50-pretrain-sgd/best.ckpt

# dropblock 
CUDA_VISIBLE_DEVICES=0,1,2,3 python faug/main.py -a gpu -n 4 -b 256 -w 16 -m 200 --save resnet50aug-blockdrop-cifar10-sgd --model resnet50_aug --lr 0.1 --optimizer sgd --feature_aug_config ./configs/cifar10/mid_prob_mid_block.yaml --feature_aug config -db monitor --dataset cifar10
```