from .plain_transform import cifar10_simple_transform
# from .trivial_aug import cifar10_complex_transform as cifar10_taug
from .complex_transform import cifar10_complex_transform as cifar10_complex_transform
from .fast_aug import cifar10_faa
from .collections import Configs

def get_feature_aug_by_name(name, config=None):
    if name == 'config':
        configs = Configs(file_name=config)
        my_transform = configs.get_transforms()
        return {
            'post_conv': my_transform,
            'post_layer1': my_transform,
            'post_layer2': my_transform,
            'post_layer3': my_transform,
            'post_layer4': my_transform}

    elif name == 'cifar10_post_conv_simple':
        my_transform = cifar10_simple_transform()
        return {'post_conv': my_transform}
    elif name == 'cifar10_post_conv_layer_1_simple':
        my_transform = cifar10_simple_transform()
        return {'post_conv': my_transform, 'post_layer1': my_transform}
    elif name == 'cifar10_post_conv_complex':
        my_transform = cifar10_complex_transform()
        return {'post_conv': my_transform}
    elif name == 'cifar10_all_complex':
        my_transform = cifar10_complex_transform()
        return {
            'post_conv': my_transform,
            'post_layer1': my_transform,
            'post_layer2': my_transform,
            'post_layer3': my_transform,
            'post_layer4': my_transform}
    elif name == 'cifar10_post_conv_complex_faa':
        my_transform = cifar10_faa()
        return {'post_conv': my_transform}
    elif name == 'cifar10_all_complex_faa':
        my_transform = cifar10_faa()
        return {
            'post_conv': my_transform,
            'post_layer1': my_transform,
            'post_layer2': my_transform,
            'post_layer3': my_transform,
            'post_layer4': my_transform}
    else:
        raise ValueError('Unknown feature augmentation name: {}'.format(name))
