import os
import argparse

# arg parser
parser = argparse.ArgumentParser(
    description='Investigate how feature augmentation would help model training')

parser.add_argument('--block', default=2, type=int, help='block size')
parser.add_argument('--epochs', default=20, type=int, help='block size')
args = parser.parse_args()


train_cmd_format = "CUDA_VISIBLE_DEVICES=0,1 python3 faug/main.py -a gpu -n 2 -b 128 -w 12 -m {epochs} --dataset cifar10 --save adaptive.block2.cifar10.{seed} --model resnet50_aug --feature_aug_config ./configs/cifar10/block/block{block}.yaml --feature_aug config -db milestone --dataset cifar10 --seed {seed}"
eval_cmd_format = "CUDA_VISIBLE_DEVICES=0,1 python3 faug/main.py -a gpu -n 2 -b 128 -w 12 -m {epochs} --dataset cifar10 --save adaptive.block2.cifar10.{seed} --model resnet50_aug --feature_aug_config ./configs/cifar10/block/block{block}.yaml --feature_aug config -db milestone --dataset cifar10 --eval --load adaptive.block{block}.cifar10.{seed}/best.ckpt"
block_id = args.block
epochs = args.epochs

for i in range(3):
    print(f"Training block {block_id} with seed {i}")
    train_cmd = train_cmd_format.format(epochs=epochs, block=block_id, seed=i)
    print(train_cmd)

for i in range(3):
    print(f"Training block {block_id} with seed {i}")
    eval_cmd = eval_cmd_format.format(epochs=epochs, block=block_id, seed=i)
    print(eval_cmd)
