from generation import query_problem, turn_into_input_format
import os, json, openai, re

def baseline_ask(args):
    if not os.path.exists(f"{args.scenario}/candidates"):
        os.mkdir(f"{args.scenario}/candidates")

    if os.path.exists(f"{args.scenario}/candidates/baseline_ask.json"):
        print("baseline_ask already exists, skipping advice generation.")
        with open(f"{args.scenario}/candidates/baseline_ask.json", "r") as f:
            answers = json.load(f)
    
    else:

        with open(f"{args.scenario}/{args.setting_path}", "r") as f:
            setting_text = f.read()

        with open(f"{args.scenario}/{args.baseline_ask_path}", "r") as f:
            baseline_ask_text = f.read()
        
        prompt = setting_text + baseline_ask_text
        prompt = turn_into_input_format("user", prompt)

        answers = query_problem(args, None, prompt, temperature=1, top_p=1, n=args.num_generations, verbose=True)
        answers = [answer["message"]["content"] for answer in answers[0]]

        with open(f"{args.scenario}/candidates/baseline_ask.json", "w") as f:
            json.dump(answers, f)

    generated_candidates = []
    for i in range(len(answers)):
        generated_candidates.append({"advice_type": "baseline_ask", \
                                     "advice_indices": [], \
                                     "advice_list": [], \
                                     "generation_index": i, \
                                     "text": answers[i]})
    return generated_candidates


def baseline_ask_with_reasoning(args):
    with open(f"{args.scenario}/{args.reasoning_prefix_path}", "r") as f:
        reasoning_prefix = f.read()

    if os.path.exists(f"{args.scenario}/candidates/baseline_ask_with_reasoning.json"):
        print("baseline_ask_with_reasoning already exists, skipping advice generation.")
        with open(f"{args.scenario}/candidates/baseline_ask_with_reasoning.json", "r") as f:
            answers = json.load(f)
    
    else: # need to construct baseline_ask_with_reasoning
        if os.path.exists(f"{args.scenario}/candidates/baseline_ask_with_reasoning_full.json"):
            print("baseline_ask_with_reasoning_full already exists, filling in baseline_ask_with_reasoning...")
            with open(f"{args.scenario}/candidates/baseline_ask_with_reasoning_full.json", "r") as f:
                answers = json.load(f)

        else: # need to construct baseline_ask_with_reasoning_full

            with open(f"{args.scenario}/{args.setting_path}", "r") as f:
                setting_text = f.read()

            with open(f"{args.scenario}/{args.baseline_ask_with_reasoning_path}", "r") as f:
                baseline_ask_with_reasoning_text = f.read()
            
            prompt = setting_text + baseline_ask_with_reasoning_text
            prompt = turn_into_input_format("user", prompt)

            answers = query_problem(args, None, prompt, temperature=1, top_p=1, n=args.num_generations, verbose=True)
            answers = [answer["message"]["content"] for answer in answers[0]]

            with open(f"{args.scenario}/candidates/baseline_ask_with_reasoning_full.json", "w") as f:
                json.dump(answers, f)

        for i in range(len(answers)):
            # remove everything before reasoning_prefix
            for line in reasoning_prefix.splitlines():
                answers[i] = re.sub(rf"[\s\S]*{line}", "", answers[i])

        with open(f"{args.scenario}/candidates/baseline_ask_with_reasoning.json", "w") as f:
            json.dump(answers, f)

    generated_candidates = []
    for i in range(len(answers)):
        generated_candidates.append({"advice_type": "baseline_ask_with_reasoning", \
                                     "advice_indices": [], \
                                     "advice_list": [], \
                                     "generation_index": i, \
                                     "text": answers[i]})

    return generated_candidates