import json
from generation import compare
import numpy as np
import os


def iterative_baseline_comparison(args, best_response, advice_type):
    with open(f"{args.scenario}/responses/{advice_type}.json", "r") as f:
        responses = json.load(f)
    
    scores = []
    for i in range(args.num_generations):
        response = responses[i]

        evaluator_scores = []
        for evaluator in (os.listdir(f"{args.scenario}/{args.eval_path}")):
            if evaluator[0] != "." and evaluator != "weights.json":
                avg_score = compare(best_response, response, args, "best", "response", advice_type, str(i), evaluator)
                evaluator_scores.append(avg_score)

        if args.verbose:
            print(f"Scores against {advice_type} generation {i}: {evaluator_scores}")
        
        scores.append(evaluator_scores)
    print(f"Average score against {advice_type}: {np.mean(scores, axis=0)}")


def combinatorial_baseline_comparison(args, best_response, advice_type):
    scores = []
    for path in os.listdir(f"{args.scenario}/responses/baseline_{advice_type}_advice"):
        with open(f"{args.scenario}/responses/baseline_{advice_type}_advice/{path}", "r") as f:
            responses = json.load(f)
        
        for i in range(args.num_generations):
            response = responses[i]

            evaluator_scores = []
            for evaluator in (os.listdir(f"{args.scenario}/{args.eval_path}")):
                if evaluator[0] != "." and evaluator != "weights.json":
                    avg_score = compare(best_response, response, args, "best_response", f"baseline_{advice_type}", path, str(i), evaluator)
                    evaluator_scores.append(avg_score)

            if args.verbose:
                print(f"Scores against baseline_{advice_type}_advice {path} response {i}: {evaluator_scores}")

            scores.append(evaluator_scores)
    print(f"Average score against baseline_{advice_type}: {np.mean(scores, axis=(0,1))}")


def best_response_baseline_compare(args, best_response):
    for evaluator in os.listdir(f"{args.scenario}/{args.eval_path}"):
        if evaluator[0] != ".": print(evaluator, end=", ")
    print("\n")
    iterative_baseline_comparison(args, best_response, "baseline_ask")
    iterative_baseline_comparison(args, best_response, "baseline_ask_with_reasoning")
    combinatorial_baseline_comparison(args, best_response, "irrelevant")
    combinatorial_baseline_comparison(args, best_response, "neutral")