# ForestPersons Seasonal Training Setup

This setup allows you to train separate object detection models on the summer and winter subsets of the ForestPersons dataset using Detectron2.

## Files Overview

### Core Files
- `seasonal_data_loader.py` - Standalone dataset registration for summer/winter subsets
- `train_summer_new.py` - Training script for summer subset
- `train_winter_new.py` - Training script for winter subset

### Configuration Files
- `configs/RCNN-FPN-CROP_forestpersons_summer.yaml` - Summer training configuration
- `configs/RCNN-FPN-CROP_forestpersons_winter.yaml` - Winter training configuration

### Launch Scripts
- `train_forestpersons_summer_new.sh` - Launch summer training
- `train_forestpersons_winter_new.sh` - Launch winter training
- `train_forestpersons_seasonal_new.sh` - Launch both or either seasonal training

## Dataset Structure

The setup expects the following ForestPersons dataset structure:
```
/mnt/home2/annonymous/ForestPersons_v3/
├── annotations/
│   ├── train_summer.json    # Summer training annotations
│   ├── val_summer.json      # Summer validation annotations
│   ├── train_winter.json    # Winter training annotations
│   └── val_winter.json      # Winter validation annotations
└── images/                  # All images (both seasons)
```

## Usage

### Training Individual Models

#### Summer Model
```bash
# Single GPU
CUDA_VISIBLE_DEVICES=0 python train_summer_new.py --num-gpus 1 --config-file configs/RCNN-FPN-CROP_forestpersons_summer.yaml

# Multiple GPUs (recommended)
bash train_forestpersons_summer_new.sh
```

#### Winter Model
```bash
# Single GPU
CUDA_VISIBLE_DEVICES=0 python train_winter_new.py --num-gpus 1 --config-file configs/RCNN-FPN-CROP_forestpersons_winter.yaml

# Multiple GPUs (recommended)
bash train_forestpersons_winter_new.sh
```

### Training Both Models
```bash
# Train both models sequentially
bash train_forestpersons_seasonal_new.sh both

# Train only summer
bash train_forestpersons_seasonal_new.sh summer

# Train only winter
bash train_forestpersons_seasonal_new.sh winter
```

## Output Directories

Training results will be saved in:
- `outputs_FPN_CROP_forestpersons_summer/` - Summer model results
- `outputs_FPN_CROP_forestpersons_winter/` - Winter model results

Each directory contains:
- Model checkpoints (`.pth` files)
- Training logs (`log.txt`)
- Evaluation metrics (`metrics.json`)
- Configuration (`config.yaml`)

## Key Features

✅ **Non-destructive**: All original files are preserved  
✅ **Standalone**: Uses separate data loader without modifying croptrain module  
✅ **Exact match**: Training scripts mirror the original `train_net.py` structure exactly  
✅ **Flexible**: Supports single or multi-GPU training  
✅ **Easy to use**: Simple shell scripts for launching training

## GPU Configuration

Adjust the `CUDA_VISIBLE_DEVICES` setting in the shell scripts based on your available GPUs:
- Single GPU: `CUDA_VISIBLE_DEVICES=0`
- Dual GPU: `CUDA_VISIBLE_DEVICES=0,1`
- Quad GPU: `CUDA_VISIBLE_DEVICES=0,1,2,3`

## Troubleshooting

1. **Import errors**: Ensure you're in the correct conda/virtual environment with Detectron2 installed
2. **Dataset not found**: Verify the dataset path in `seasonal_data_loader.py` matches your setup
3. **GPU memory issues**: Reduce `IMS_PER_BATCH` in the config files if you encounter OOM errors

## Training Script Structure

The training scripts (`train_summer_new.py` and `train_winter_new.py`) exactly mirror the original `train_net.py` structure:
- Same imports and setup functions
- Same trainer initialization (BaselineTrainer)
- Same evaluation logic without TTA
- Same main execution flow
- Only difference: seasonal dataset registration using `seasonal_data_loader.py`

## Dataset Registration

The `seasonal_data_loader.py` file registers the following datasets:
- `missing_person_summer_train` - Summer training set
- `missing_person_summer_test` - Summer validation set  
- `missing_person_winter_train` - Winter training set
- `missing_person_winter_test` - Winter validation set