import json

# 경로 설정
pred_json_path = "/mnt/home/annonymous/neurips2025/drone_detectron2/DroneDetectron2/coco_instances_results_all.json"
output_json_path = "converted_coco_instances_results_all.json"


# 2. Prediction JSON 불러오기
with open(pred_json_path, 'r') as f:
    pred_data = json.load(f)

# 3. image_id 변환
converted = []
for ann in pred_data:
    new_ann = ann.copy()
    new_ann["category_id"] = 0  # forestpersons 단일 클래스이므로 category_id를 0으로 고정
    converted.append(new_ann)

# 4. 저장
with open(output_json_path, 'w') as f:
    json.dump(converted, f)

print(f"✅ Converted prediction saved to {output_json_path}")
