"""
Dataset registration functions for seasonal subsets of ForestPersons dataset.
"""

from detectron2.data.datasets import register_coco_instances
from detectron2.data import MetadataCatalog

dataset_root = "/mnt/home2/annonymous/ForestPersons_v3"


def register_forestpersons_summer(cfg=None):
    """
    Register the ForestPersons Summer subset dataset with Detectron2.
    
    Args:
        cfg: Configuration object (unused but kept for consistency)
    """
    # Register training and validation datasets for summer subset
    register_coco_instances(
        "missing_person_summer_train", 
        {}, 
        f"{dataset_root}/annotations/train_summer.json", 
        f"{dataset_root}/images"
    )
    register_coco_instances(
        "missing_person_summer_test", 
        {}, 
        f"{dataset_root}/annotations/val_summer.json", 
        f"{dataset_root}/images"
    )
    
    # Set metadata for evaluation
    MetadataCatalog.get("missing_person_summer_train").set(
        thing_classes=["person"],
        evaluator_type="coco"
    )
    MetadataCatalog.get("missing_person_summer_test").set(
        thing_classes=["person"],
        evaluator_type="coco"
    )


def register_forestpersons_winter(cfg=None):
    """
    Register the ForestPersons Winter subset dataset with Detectron2.
    
    Args:
        cfg: Configuration object (unused but kept for consistency)
    """
    # Register training and validation datasets for winter subset
    register_coco_instances(
        "missing_person_winter_train", 
        {}, 
        f"{dataset_root}/annotations/train_winter.json", 
        f"{dataset_root}/images"
    )
    register_coco_instances(
        "missing_person_winter_test", 
        {}, 
        f"{dataset_root}/annotations/val_winter.json", 
        f"{dataset_root}/images"
    )
    
    # Set metadata for evaluation
    MetadataCatalog.get("missing_person_winter_train").set(
        thing_classes=["person"],
        evaluator_type="coco"
    )
    MetadataCatalog.get("missing_person_winter_test").set(
        thing_classes=["person"],
        evaluator_type="coco"
    )


def register_forestpersons_combined(cfg=None):
    """
    Register both seasonal subsets together for comparison purposes.
    
    Args:
        cfg: Configuration object (unused but kept for consistency)
    """
    register_forestpersons_summer(cfg)
    register_forestpersons_winter(cfg)