#!/bin/bash

# First create a temporary Python script that registers the dataset
# cat > register_dataset.py << EOL
# from missing_person_data import register_missing_person_dataset

# # Register all splits of the dataset
# register_missing_person_dataset()
# print("Dataset registration completed.")
# EOL

# # Register the dataset first
# python register_dataset.py

# Standard Forest Persons model
# CUDA_VISIBLE_DEVICES=0 python train_net.py \
#       --eval-only \
#       --num-gpus 1 \
#       --config-file configs/RCNN-FPN-CROP_forestpersons.yaml \
#       MODEL.WEIGHTS outputs_FPN_CROP_forestpersons_fix/model_final.pth \
#       OUTPUT_DIR outputs_FPN_CROP_forestpersons/inference \
#       DATASETS.TEST '("missing_person_original_test",)'

# for mode in "winter" "summer" "standing"
# do
# CUDA_VISIBLE_DEVICES=0 python train_net.py \
#       --eval-only \
#       --num-gpus 1 \
#       --config-file configs/RCNN-FPN-CROP_forestpersons.yaml \
#       MODEL.WEIGHTS outputs_${mode}/model_final.pth \
#       OUTPUT_DIR outputs_${mode}/inference \
#       DATASETS.TEST '("missing_person_original_test",)'
# CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python train_net.py \
#       --eval-only \
#       --num-gpus  \
#       --config-file configs/RCNN-FPN-CROP_forestpersons.yaml \
#       MODEL.WEIGHTS outputs_${mode}/model_final.pth \
#       OUTPUT_DIR outputs_${mode}/inference \
#       DATASETS.TEST '("missing_person_original_test",)'
# done


#===

CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python train_net.py \
      --eval-only \
      --num-gpus 8 \
      --config-file configs/RCNN-FPN-CROP_forestpersons.yaml \
      MODEL.WEIGHTS outputs_FPN_CROP_forestpersons_fix/model_final.pth \
      OUTPUT_DIR outputs_FPN_CROP_forestpersons_fix/inference \
      DATASETS.TEST '("missing_person_original_test",)'


# CUDA_VISIBLE_DEVICES=0,1,2,3,4,5,6,7 python train_net.py \
#       --eval-only \
#       --num-gpus 8 \
#       --config-file configs/RCNN-FPN-CROP_forestpersons.yaml \
#       MODEL.WEIGHTS outputs_FPN_CROP_forestpersons_fix/model_final.pth \
#       OUTPUT_DIR outputs_FPN_CROP_forestpersons_fix/inference \
#       DATASETS.TEST '("missing_person_original_val",)'

