#!/bin/bash

# Combined training script for both ForestPersons seasonal subsets
# Usage: bash train_forestpersons_seasonal.sh [summer|winter|both]

SEASON=${1:-both}

if [ "$SEASON" = "summer" ] || [ "$SEASON" = "both" ]; then
    echo "==========================================="
    echo "Starting ForestPersons Summer training..."
    echo "==========================================="
    
    CUDA_VISIBLE_DEVICES=0,1,2,3 python train_summer.py \
          --num-gpus 4 \
          --config-file configs/RCNN-FPN-CROP_forestpersons_summer.yaml
    
    echo "Summer training completed!"
    echo "Results saved in: outputs_FPN_CROP_forestpersons_summer/"
    echo ""
fi

if [ "$SEASON" = "winter" ] || [ "$SEASON" = "both" ]; then
    echo "==========================================="
    echo "Starting ForestPersons Winter training..."
    echo "==========================================="
    
    CUDA_VISIBLE_DEVICES=0,1,2,3 python train_winter.py \
          --num-gpus 4 \
          --config-file configs/RCNN-FPN-CROP_forestpersons_winter.yaml
    
    echo "Winter training completed!"
    echo "Results saved in: outputs_FPN_CROP_forestpersons_winter/"
    echo ""
fi

echo "==========================================="
echo "All seasonal training completed!"
echo "==========================================="
if [ "$SEASON" = "both" ]; then
    echo "Summer results: outputs_FPN_CROP_forestpersons_summer/"
    echo "Winter results: outputs_FPN_CROP_forestpersons_winter/"
fi