#!/bin/bash

# Combined training script for both ForestPersons seasonal subsets (new version)
# Usage: bash train_forestpersons_seasonal_new.sh [summer|winter|both]

SEASON=${1:-both}

echo "==========================================="
echo "ForestPersons Seasonal Training Script"
echo "Mode: $SEASON"
echo "==========================================="

if [ "$SEASON" = "summer" ] || [ "$SEASON" = "both" ]; then
    echo ""
    echo "==========================================="
    echo "Starting ForestPersons Summer training..."
    echo "==========================================="
    
    CUDA_VISIBLE_DEVICES=0,1,2,3 python train_summer_new.py \
          --num-gpus 4 \
          --config-file configs/RCNN-FPN-CROP_forestpersons_summer.yaml \
          OUTPUT_DIR ./outputs_summer
    
    echo ""
    echo "Summer training completed!"
    echo "Results saved in: outputs_FPN_CROP_forestpersons_summer/"
    echo ""
fi

if [ "$SEASON" = "winter" ] || [ "$SEASON" = "both" ]; then
    echo ""
    echo "==========================================="
    echo "Starting ForestPersons Winter training..."
    echo "==========================================="
    
    CUDA_VISIBLE_DEVICES=0,1,2,3 python train_winter_new.py \
          --num-gpus 4 \
          --config-file configs/RCNN-FPN-CROP_forestpersons_winter.yaml \
          OUTPUT_DIR ./outputs_winter
    
    echo ""
    echo "Winter training completed!"
    echo "Results saved in: outputs_FPN_CROP_forestpersons_winter/"
    echo ""
fi

echo "==========================================="
echo "All seasonal training completed!"
echo "==========================================="
if [ "$SEASON" = "both" ]; then
    echo "Summer results: outputs_FPN_CROP_forestpersons_summer/"
    echo "Winter results: outputs_FPN_CROP_forestpersons_winter/"
elif [ "$SEASON" = "summer" ]; then
    echo "Summer results: outputs_FPN_CROP_forestpersons_summer/"
elif [ "$SEASON" = "winter" ]; then
    echo "Winter results: outputs_FPN_CROP_forestpersons_winter/"
fi
echo "==========================================="