#!/bin/bash

# Training script for ForestPersons Standing subset (new version)
# Usage: bash train_forestpersons_standing_new.sh

echo "==========================================="
echo "Starting ForestPersons Standing Training"
echo "==========================================="

# Set CUDA devices - adjust according to your GPU setup
# For single GPU training:
# CUDA_VISIBLE_DEVICES=0 python train_standing_new.py \
#       --num-gpus 1 \
#       --config-file configs/RCNN-FPN-CROP_forestpersons_standing.yaml

# For dual GPU training:
# CUDA_VISIBLE_DEVICES=0,1 python train_standing_new.py \
#       --num-gpus 2 \
#       --config-file configs/RCNN-FPN-CROP_forestpersons_standing.yaml

# For quad GPU training (recommended for faster training):
CUDA_VISIBLE_DEVICES=4,5,6,7 python train_standing_new.py \
      --num-gpus 4 \
      --config-file configs/RCNN-FPN-CROP_forestpersons_standing.yaml \
      OUTPUT_DIR ./outputs_standing2

echo ""
echo "==========================================="
echo "Training completed for ForestPersons Standing subset"
echo "Results saved in: outputs_FPN_CROP_forestpersons_standing/"
echo "==========================================="