#!/bin/bash

# Training script for ForestPersons Summer subset (new version)
# Usage: bash train_forestpersons_summer_new.sh

echo "==========================================="
echo "Starting ForestPersons Summer Training"
echo "==========================================="

# Set CUDA devices - adjust according to your GPU setup
# For single GPU training:
# CUDA_VISIBLE_DEVICES=0 python train_summer_new.py \
#       --num-gpus 1 \
#       --config-file configs/RCNN-FPN-CROP_forestpersons_summer.yaml

# For dual GPU training:
# CUDA_VISIBLE_DEVICES=0,1 python train_summer_new.py \
#       --num-gpus 2 \
#       --config-file configs/RCNN-FPN-CROP_forestpersons_summer.yaml

# For quad GPU training (recommended for faster training):
CUDA_VISIBLE_DEVICES=0,1,2,3 python train_summer_new.py \
      --num-gpus 4 \
      --config-file configs/RCNN-FPN-CROP_forestpersons_summer.yaml

echo ""
echo "==========================================="
echo "Training completed for ForestPersons Summer subset"
echo "Results saved in: outputs_FPN_CROP_forestpersons_summer/"
echo "==========================================="