#!/bin/bash

# Training script for ForestPersons Winter subset
# Usage: bash train_forestpersons_winter.sh

# Set CUDA devices - adjust according to your GPU setup
# For single GPU training:
# CUDA_VISIBLE_DEVICES=0 python train_winter.py \
#       --num-gpus 1 \
#       --config-file configs/RCNN-FPN-CROP_forestpersons_winter.yaml

# For dual GPU training:
# CUDA_VISIBLE_DEVICES=0,1 python train_winter.py \
#       --num-gpus 2 \
#       --config-file configs/RCNN-FPN-CROP_forestpersons_winter.yaml

# For quad GPU training (recommended for faster training):
CUDA_VISIBLE_DEVICES=0,1,2,3 python train_winter.py \
      --num-gpus 4 \
      --config-file configs/RCNN-FPN-CROP_forestpersons_winter.yaml

echo "Training completed for ForestPersons Winter subset"
echo "Results saved in: outputs_FPN_CROP_forestpersons_winter/"