#!/bin/bash

# Training script for ForestPersons Winter subset (new version)
# Usage: bash train_forestpersons_winter_new.sh

echo "==========================================="
echo "Starting ForestPersons Winter Training"
echo "==========================================="

# Set CUDA devices - adjust according to your GPU setup
# For single GPU training:
# CUDA_VISIBLE_DEVICES=0 python train_winter_new.py \
#       --num-gpus 1 \
#       --config-file configs/RCNN-FPN-CROP_forestpersons_winter.yaml

# For dual GPU training:
# CUDA_VISIBLE_DEVICES=0,1 python train_winter_new.py \
#       --num-gpus 2 \
#       --config-file configs/RCNN-FPN-CROP_forestpersons_winter.yaml

# For quad GPU training (recommended for faster training):
CUDA_VISIBLE_DEVICES=0,1,2,3 python train_winter_new.py \
      --num-gpus 4 \
      --config-file configs/RCNN-FPN-CROP_forestpersons_winter.yaml

echo ""
echo "==========================================="
echo "Training completed for ForestPersons Winter subset"
echo "Results saved in: outputs_FPN_CROP_forestpersons_winter/"
echo "==========================================="