from pycocotools.coco import COCO
from pycocotools.cocoeval import COCOeval
import json

# GT annotation 파일 (COCO format)
gt_json_path = '/mnt/home/annonymous/layout_diffusion/yolov11_forestpersons/drone_detectron2/DroneDetectron2/croptrain/data/datasets/VisDrone/annotations_VisDrone_val.json'

# Prediction 파일 (Ultralytics에서 저장한 predictions.json)
pred_json_path = '/mnt/home/annonymous/layout_diffusion/yolov11_forestpersons/drone_detectron2/DroneDetectron2/outputs_FPN_CROP_forestpersons/inference/coco_instances_results.json'

# 1. Load ground truth and predictions
coco_gt = COCO(gt_json_path)
coco_dt = coco_gt.loadRes(pred_json_path)

# 2. Create COCOeval object
coco_eval = COCOeval(coco_gt, coco_dt, iouType='bbox')

# 3. Run evaluation
coco_eval.evaluate()
coco_eval.accumulate()
coco_eval.summarize()

# 4. Extract mAR@0.5:0.95 (IoU=0.5:0.95, maxDets=100)
mar_50_95 = coco_eval.stats[8]
print(f"mAR@0.5:0.95 = {mar_50_95:.4f}")
