# dataset_type = 'MissingPersonDataset'  # Dataset type, this will be used to define the dataset
# data_root = '/mnt/home2/annonymous/ForestPersons_v3'  # Root path of data
# backend_args = None # Arguments to instantiate the corresponding file backend

_base_ = [
    "./missing_person_v3_data_root.py",
]

# _base_ = [
#     "./missing_person_config.py",
# ]

# # dataset settings
# data_root = 'data/coco/'
# dataset_type = 'CocoDataset'

# # Example to use different file client
# # Method 1: simply set the data root and let the file I/O module
# # automatically infer from prefix (not support LMDB and Memcache yet)

# # data_root = 's3://openmmlab/datasets/detection/coco/'

# # Method 2: Use `backend_args`, `file_client_args` in versions before 3.0.0rc6
# # backend_args = dict(
# #     backend='petrel',
# #     path_mapping=dict({
# #         './data/': 's3://openmmlab/datasets/detection/',
# #         'data/': 's3://openmmlab/datasets/detection/'
# #     }))

img_scale = (640, 640)  # width, height
backend_args = None

train_pipeline = [
    dict(type='Mosaic', img_scale=img_scale, pad_val=114.0),
    dict(
        type='RandomAffine',
        scaling_ratio_range=(0.5, 1.5),
        # img_scale is (width, height)
        border=(-img_scale[0] // 2, -img_scale[1] // 2)),
    dict(type='YOLOXHSVRandomAug'),
    dict(type='RandomFlip', prob=0.5),
    # Resize and Pad are for the last 15 epochs when Mosaic and
    # RandomAffine are closed by YOLOXModeSwitchHook.
    dict(type='Resize', scale=img_scale, keep_ratio=True),
    dict(
        type='Pad',
        pad_to_square=True,
        pad_val=dict(img=(114.0, 114.0, 114.0))),
    dict(type='FilterAnnotations', min_gt_bbox_wh=(1, 1), keep_empty=False),
    dict(type='PackDetInputs')
]


train_dataset = dict(
    # use MultiImageMixDataset wrapper to support mosaic and mixup
    type='MultiImageMixDataset',
    dataset=dict(
        type=_base_.dataset_type,
        data_root=_base_.data_root,
        ann_file=_base_.ann_file["train"],
        data_prefix=_base_.img_prefix,
        pipeline=[
            dict(type='LoadImageFromFile', backend_args=_base_.backend_args),
            dict(type='LoadAnnotations', with_bbox=True)
        ],
        filter_cfg=dict(filter_empty_gt=False, min_size=32),
        backend_args=_base_.backend_args),
    pipeline=train_pipeline)

test_pipeline = [
    dict(type='LoadImageFromFile', backend_args=_base_.backend_args),
    dict(type='Resize', scale=(416, 416), keep_ratio=True),
    dict(
        type='Pad',
        pad_to_square=True,
        pad_val=dict(img=(114.0, 114.0, 114.0))),
    dict(type='LoadAnnotations', with_bbox=True),
    dict(
        type='PackDetInputs',
        meta_keys=('img_id', 'img_path', 'ori_shape', 'img_shape',
                   'scale_factor'))
]

train_dataloader = dict(
    batch_size=32,
    num_workers=4,
    persistent_workers=True,
    sampler=dict(type='DefaultSampler', shuffle=True),
    dataset=train_dataset)
val_dataloader = dict(
    batch_size=32,
    num_workers=4,
    persistent_workers=True,
    drop_last=False,
    sampler=dict(type='DefaultSampler', shuffle=False),
    dataset=dict(
        type=_base_.dataset_type,
        data_root=_base_.data_root,
        ann_file=_base_.ann_file["val"],
        data_prefix=_base_.img_prefix,
        test_mode=True,
        pipeline=test_pipeline,
        backend_args=backend_args))

test_dataloader = dict(
    batch_size=32,
    num_workers=4,
    persistent_workers=True,
    drop_last=False,
    sampler=dict(type='DefaultSampler', shuffle=False),
    dataset=dict(
        type=_base_.dataset_type,
        data_root=_base_.data_root,
        ann_file=_base_.ann_file["test"],
        data_prefix=_base_.img_prefix,
        test_mode=True,
        pipeline=test_pipeline,
        backend_args=backend_args))

# val_evaluator = dict(
#     type='CocoMetric',
#     ann_file=data_root + 'annotations/instances_val2017.json',
#     metric='bbox',
#     backend_args=backend_args)
# test_evaluator = val_evaluator



# DEFAULT_TRAIN_DATASET_PIPELINE = [
#     dict(type='LoadImageFromFile', backend_args=backend_args),
#     dict(type='LoadAnnotations', with_bbox=True),
#     dict(type='Resize', scale=(1333, 800), keep_ratio=True),
#     dict(type='RandomFlip', prob=0.5),
#     dict(type='PackDetInputs')
# ]

# DEFAULT_VAL_DATASET_PIPELINE = [
#     dict(type='LoadImageFromFile', backend_args=backend_args),
#     dict(type='Resize', scale=(1333, 800), keep_ratio=True),
#     # If you don't have a gt annotation, delete the pipeline
#     dict(type='LoadAnnotations', with_bbox=True),
#     dict(
#         type='PackDetInputs',
#         meta_keys=('img_id', 'img_path', 'ori_shape', 'img_shape',
#                    'scale_factor'))
# ]

# DEFAULT_TRAIN_DATALOADER_DICT = dict(   # Train dataloader config
#     batch_size=8,  # Batch size of a single GPU => total batch size should be 16
#     num_workers=2,  # Worker to pre-fetch data for each single GPU
#     persistent_workers=True,  # If ``True``, the dataloader will not shut down the worker processes after an epoch end, which can accelerate training speed.
#     sampler=dict(  # training data sampler
#         type='DefaultSampler',  # DefaultSampler which supports both distributed and non-distributed training. Refer to https://mmengine.readthedocs.io/en/latest/api/generated/mmengine.dataset.DefaultSampler.html#mmengine.dataset.DefaultSampler
#         shuffle=True),  # randomly shuffle the training data in each epoch
#     batch_sampler=dict(type='AspectRatioBatchSampler'),  # Batch sampler for grouping images with similar aspect ratio into a same batch. It can reduce GPU memory cost.
#     dataset=dict(  # Train dataset config
#         type=dataset_type,
#         data_root=data_root,
#         ann_file='split_data/train.json',  # Path of annotation file
#         data_prefix=dict(img='images/'),  # Prefix of image path
#         # filter_cfg=dict(filter_empty_gt=True, min_size=32),  # Config of filtering images and annotations
#         filter_cfg=dict(min_size=32),
#         pipeline=DEFAULT_TRAIN_DATASET_PIPELINE,
#         backend_args=backend_args))

# DEFAULT_VAL_DATALOADER_DICT = dict(  # Validation dataloader config
#     batch_size=8,  # Batch size of a single GPU. If batch-size > 1, the extra padding area may influence the performance.
#     num_workers=2,  # Worker to pre-fetch data for each single GPU
#     persistent_workers=True,  # If ``True``, the dataloader will not shut down the worker processes after an epoch end, which can accelerate training speed.
#     drop_last=False,  # Whether to drop the last incomplete batch, if the dataset size is not divisible by the batch size
#     sampler=dict(
#         type='DefaultSampler',
#         shuffle=False),  # not shuffle during validation and testing
#     dataset=dict(
#         type=dataset_type,
#         data_root=data_root,
#         ann_file='split_data/val.json',
#         data_prefix=dict(img='images/'),
#         test_mode=True,  # Turn on the test mode of the dataset to avoid filtering annotations or images
#         pipeline=DEFAULT_VAL_DATASET_PIPELINE,
#         backend_args=backend_args))

# DEFAULT_TEST_DATALOADER_DICT = dict(  # Validation dataloader config
#     batch_size=8,  # Batch size of a single GPU. If batch-size > 1, the extra padding area may influence the performance.
#     num_workers=2,  # Worker to pre-fetch data for each single GPU
#     persistent_workers=True,  # If ``True``, the dataloader will not shut down the worker processes after an epoch end, which can accelerate training speed.
#     drop_last=False,  # Whether to drop the last incomplete batch, if the dataset size is not divisible by the batch size
#     sampler=dict(
#         type='DefaultSampler',
#         shuffle=False),  # not shuffle during validation and testing
#     dataset=dict(
#         type=dataset_type,
#         data_root=data_root,
#         ann_file='split_data/test.json',
#         data_prefix=dict(img='images/'),
#         test_mode=True,  # Turn on the test mode of the dataset to avoid filtering annotations or images
#         pipeline=DEFAULT_VAL_DATASET_PIPELINE,
#         backend_args=backend_args))

# train_dataloader = DEFAULT_TRAIN_DATALOADER_DICT
# val_dataloader = DEFAULT_VAL_DATALOADER_DICT # TMP
# test_dataloader = DEFAULT_TEST_DATALOADER_DICT # TMP


# img_scale = (640, 640)  # width, height


# train_pipeline = [
#     dict(type='Mosaic', img_scale=img_scale, pad_val=114.0),
#     dict(
#         type='RandomAffine',
#         scaling_ratio_range=(0.5, 1.5),
#         # img_scale is (width, height)
#         border=(-img_scale[0] // 2, -img_scale[1] // 2)),
#     dict(type='YOLOXHSVRandomAug'),
#     dict(type='RandomFlip', prob=0.5),
#     # Resize and Pad are for the last 15 epochs when Mosaic and
#     # RandomAffine are closed by YOLOXModeSwitchHook.
#     dict(type='Resize', scale=img_scale, keep_ratio=True),
#     dict(
#         type='Pad',
#         pad_to_square=True,
#         pad_val=dict(img=(114.0, 114.0, 114.0))),
#     dict(type='FilterAnnotations', min_gt_bbox_wh=(1, 1), keep_empty=False),
#     dict(type='PackDetInputs')
# ]

# test_pipeline = [
#     dict(type='LoadImageFromFile', backend_args={{_base_.backend_args}}),
#     dict(type='Resize', scale=(416, 416), keep_ratio=True),
#     dict(
#         type='Pad',
#         pad_to_square=True,
#         pad_val=dict(img=(114.0, 114.0, 114.0))),
#     dict(type='LoadAnnotations', with_bbox=True),
#     dict(
#         type='PackDetInputs',
#         meta_keys=('img_id', 'img_path', 'ori_shape', 'img_shape',
#                    'scale_factor'))
# ]
# train_dataset = 

# train_dataloader = dict(dataset=dict(pipeline=train_pipeline))
# val_dataloader = dict(dataset=dict(pipeline=test_pipeline))
# test_dataloader = val_dataloader