# custom_imports = dict(
#     imports=[
#         'dataset.missing_person', 
#         'metrics.missing_person_metric'
#     ],
#     allow_failed_imports=False
# )

# _base_ = [
#     '_base_/default_runtime.py',
#     '_base_/schedules/schedule_1x.py',
#     'models/detr/detr_missing_person.py',
#     # 'evaluator/missing_person_evaluator.py',
#     # 'data/missing_person_config.py',
#     'data/missing_person_v3_config.py',
#     'evaluator/missing_person_v3_evaluator.py',
# ]

# # # learning policy


# # only keep latest 2 checkpoints
# # default_hooks = dict(checkpoint=dict(max_keep_ckpts=2))
# default_hooks = dict(
#     checkpoint=dict(
#         type="CheckpointHook",
#         save_best="coco/bbox_mAP",
#         rule="greater",
#         max_keep_ckpts=2
#     )
# )

# max_epochs = 150
# train_cfg = dict(
#     type='EpochBasedTrainLoop', max_epochs=max_epochs, val_interval=1)
# val_cfg = dict(type='ValLoop')
# test_cfg = dict(type='TestLoop')

# param_scheduler = [
#     dict(
#         type='MultiStepLR',
#         begin=0,
#         end=max_epochs,
#         by_epoch=True,
#         milestones=[100],
#         gamma=0.1)
# ]

custom_imports = dict(
    imports=[
        'dataset.missing_person', 
        'metrics.missing_person_metric'
    ],
    allow_failed_imports=False
)

_base_ = [
    'models/detr/detr_missing_person.py',
    'evaluator/missing_person_v3_evaluator.py',
]


default_hooks = dict(
    checkpoint=dict(
        type="CheckpointHook",
        save_best="coco/bbox_mAP",
        rule="greater",
        max_keep_ckpts=2
    )
)


# # NOTE: `auto_scale_lr` is for automatically scaling LR,
# # USER SHOULD NOT CHANGE ITS VALUES.
# # base_batch_size = (8 GPUs) x (2 samples per GPU)
# auto_scale_lr = dict(base_batch_size=16)