#/bin/bash

project_dirs=missing_person
exp_name=250422_missing_person_yolox
cuda_visible_devices=4
port=29501

gpus=$(echo $cuda_visible_devices | grep -o "," | wc -l)
gpus=$((gpus+1))

echo gpus: $gpus


config_name=exp_config/yolox.yaml
checkpoint=/mnt/home/annonymous/iclr2026/mmdet/missing_person/250503_missing_person_yolox_forestperson_v3/best_coco_bbox_mAP_epoch_17.pth


# config_name=exp_config/ssd.yaml
# checkpoint=

if [ "$gpus" -eq 1 ]; then
    echo "Single GPU"
    # CUDA_VISIBLE_DEVICES=$cuda_visible_devices python train.py --config exp_configs/$config_name
    CUDA_VISIBLE_DEVICES=$cuda_visible_devices python inference.py --config $config_name --checkpoint $checkpoint --project_dir $project_dirs --exp_name $exp_name
else
    echo "Multiple GPUs"
    echo "CUDA_VISIBLE_DEVICES=$cuda_visible_devices"

        CUDA_VISIBLE_DEVICES=$cuda_visible_devices python -m torch.distributed.launch \
            --nproc_per_node=$gpus \
            --master-port $port \
            inference.py \
            --config $config_name \
            --launcher pytorch \
            --project_dir $project_dirs \
            --exp_name $exp_name \
            --checkpoint $checkpoint \ 

fi
