#/bin/bash

project_dirs=missing_person
exp_name=250503_missing_person_faster_rcnn_forestperson_v3
cuda_visible_devices=4,5
port=29501

gpus=$(echo $cuda_visible_devices | grep -o "," | wc -l)
gpus=$((gpus+1))

echo gpus: $gpus

config_name=exp_config/faster_rcnn.yaml

if [ "$gpus" -eq 1 ]; then
    echo "Single GPU"
    # CUDA_VISIBLE_DEVICES=$cuda_visible_devices python train.py --config exp_configs/$config_name
    CUDA_VISIBLE_DEVICES=$cuda_visible_devices python train.py --config $config_name
else
    echo "Multiple GPUs"
    echo "CUDA_VISIBLE_DEVICES=$cuda_visible_devices"

        CUDA_VISIBLE_DEVICES=$cuda_visible_devices python -m torch.distributed.launch \
            --nproc_per_node=$gpus \
            --master-port $port \
            train.py \
            --config $config_name \
            --launcher pytorch \
            --project_dir $project_dirs \
            --exp_name $exp_name \

fi


# config_name=$experiment_name/0.yaml
# bash /mnt/home/annonymous/layout_diffusion/additional_obj_det_models/coreset/scripts/select_coreset.sh     /mnt/home/annonymous/layout_diffusion/additional_obj_det_models/exp_configs/$config_name     $cuda_visible_devices     $port
