# YOLOv11 ForestPersons Seasonal Training

This directory contains a complete setup for training YOLOv11 object detection models on seasonal subsets of the ForestPersons dataset.

## 📊 Dataset Statistics

| Split | Summer Images | Winter Images | Total |
|-------|---------------|---------------|-------|
| Train | 26,468 | 36,512 | 62,980 |
| Val   | 5,192  | 10,115 | 15,307 |
| Test  | 7,751  | 1,661  | 9,412  |

## 🗂️ Directory Structure

```
yolov11_forestpersons/
├── data/
│   ├── forestpersons_summer.yaml    # Summer dataset config
│   ├── forestpersons_winter.yaml    # Winter dataset config
│   ├── train_summer.txt             # Summer training image paths
│   ├── val_summer.txt               # Summer validation image paths
│   ├── test_summer.txt              # Summer test image paths
│   ├── train_winter.txt             # Winter training image paths
│   ├── val_winter.txt               # Winter validation image paths
│   ├── test_winter.txt              # Winter test image paths
│   ├── images/                      # Symlink to ForestPersons images
│   └── labels/                      # YOLO format labels
├── train_summer.py                  # Summer training script
├── train_winter.py                  # Winter training script
├── train_summer.sh                  # Summer training launcher
├── train_winter.sh                  # Winter training launcher
├── create_season_splits.py          # Script to generate seasonal splits
└── yolo11n.pt                      # Pretrained YOLOv11 nano model
```

## 🚀 Quick Start

### 1. Generate Seasonal Splits (Already Done)
```bash
python create_season_splits.py
```

### 2. Train Summer Model
```bash
# Using shell script (recommended)
bash train_summer.sh

# Or directly with Python
python train_summer.py
```

### 3. Train Winter Model
```bash
# Using shell script (recommended)
bash train_winter.sh

# Or directly with Python
python train_winter.py
```

## ⚙️ Training Configuration

Both seasonal training scripts are configured with:

- **Model**: YOLOv11 Nano (yolov11n)
- **Epochs**: 100
- **Image Size**: 640px
- **Batch Size**: 16
- **Devices**: GPU 4,5 (configurable)
- **Optimizer**: AdamW
- **Learning Rate**: 0.01
- **Early Stopping**: 50 epochs patience
- **Checkpoints**: Saved every 10 epochs

## 📁 Training Results

Results will be saved in:
- Summer: `runs/forestpersons_summer/yolov11n/`
- Winter: `runs/forestpersons_winter/yolov11n/`

Each results directory contains:
- `weights/best.pt` - Best model weights
- `weights/last.pt` - Latest model weights
- `results.png` - Training curves
- `confusion_matrix.png` - Confusion matrix
- `val_batch*.jpg` - Validation visualizations

## 🔧 Customization

### Modify Training Parameters
Edit `train_summer.py` or `train_winter.py` to change:
- Model size (yolov11n, yolov11s, yolov11m, yolov11l)
- Epochs, batch size, learning rate
- GPU device selection
- Training hyperparameters

### GPU Configuration
Change the `device` parameter in the training scripts:
```python
device = [0, 1]        # Use GPUs 0 and 1
device = [4, 5, 6, 7]  # Use GPUs 4, 5, 6, 7
device = 0             # Use single GPU 0
```

## 📈 Monitoring Training

Monitor training progress with:
```bash
# Watch GPU usage
watch -n 1 nvidia-smi

# View training logs
tail -f runs/forestpersons_summer/yolov11n/train/results.csv
tail -f runs/forestpersons_winter/yolov11n/train/results.csv
```

## 🧪 Model Evaluation

After training, evaluate models on test sets:
```bash
# Summer model evaluation
yolo val model=runs/forestpersons_summer/yolov11n/weights/best.pt data=data/forestpersons_summer.yaml

# Winter model evaluation  
yolo val model=runs/forestpersons_winter/yolov11n/weights/best.pt data=data/forestpersons_winter.yaml
```

## 🔄 Resume Training

Training automatically resumes from the last checkpoint if interrupted. To start fresh:
```bash
# Remove existing results directory
rm -rf runs/forestpersons_summer/yolov11n/
rm -rf runs/forestpersons_winter/yolov11n/
```

## 🎯 Next Steps

1. **Cross-Season Evaluation**: Test summer-trained model on winter data and vice versa
2. **Model Comparison**: Compare performance between seasonal and combined training
3. **Hyperparameter Tuning**: Optimize learning rates, augmentations, etc.
4. **Ensemble Methods**: Combine summer and winter models for robust detection

## 📞 Support

- Check the training logs in `runs/forestpersons_*/yolov11n/`
- Monitor GPU memory usage with `nvidia-smi`
- Adjust batch size if you encounter CUDA out of memory errors