import json

# 경로 설정
gt_json_path = "/mnt/home2/annonymous/ForestPersons_v3/annotations/test.json"
pred_json_path = "/mnt/home/annonymous/iclr2026/yolov11_forestpersons/runs/detect/val41/predictions.json"
output_json_path = "converted_predictions_test_trained_with_standing.json"

with open(gt_json_path, 'r') as f:
    gt_data = json.load(f)

filename_to_id = {
    img['file_name'].split("/")[-1].split(".")[0]: img['id']
    for img in gt_data['images']
}

with open(pred_json_path, 'r') as f:
    pred_data = json.load(f)

converted = []
for ann in pred_data:
    file_name = ann['image_id']
    if file_name not in filename_to_id:
        breakpoint()
        print(f"⚠️ Warning: {file_name} not found in GT!")
        continue
    new_ann = ann.copy()
    new_ann['image_id'] = filename_to_id[file_name]
    new_ann["category_id"] = 0
    converted.append(new_ann)

with open(output_json_path, 'w') as f:
    json.dump(converted, f)

print(f"✅ Converted prediction saved to {output_json_path}")
