import json

# 원본 GT JSON 경로
input_gt_path = '/mnt/home2/annonymous/data_2025/ann_v3.0/test.json'

# 저장할 경로
output_gt_path = 'converted_test.json'

# 1. Load GT JSON
with open(input_gt_path, 'r') as f:
    gt_data = json.load(f)

# 2. 모든 annotation의 category_id를 0으로 변경
for ann in gt_data['annotations']:
    ann['category_id'] = 0

# 3. categories 필드도 단일 클래스(id=0, name='person')로 대체
gt_data['categories'] = [{
    'id': 0,
    'name': 'person',
    'supercategory': 'person'
}]

# 4. 저장
with open(output_gt_path, 'w') as f:
    json.dump(gt_data, f)

print(f"✅ Saved converted GT JSON to: {output_gt_path}")
