import json
from pycocotools.coco import COCO
from pycocotools.cocoeval import COCOeval

ground_truth_json_path = "data_forestpersons_v3/val.json"

# model.val() 실행 시 runs/detect/val/predictions.json 와 같이 생성됩니다.
prediction_json_path = "converted_predictions_test_val31.json"

coco_gt = COCO(ground_truth_json_path)

coco_dt = coco_gt.loadRes(prediction_json_path)

coco_eval = COCOeval(coco_gt, coco_dt, 'bbox')

print("Running COCO evaluation...")

coco_eval.evaluate()

coco_eval.accumulate()

coco_eval.summarize()
print("Evaluation finished.")

map_50_95 = coco_eval.stats[0]
map_50 = coco_eval.stats[1]
ar_100 = coco_eval.stats[8]

print(f"\n--- Key Metrics ---")
print(f"mAP@.5:.95: {map_50_95:.4f}")
print(f"mAP@.5:     {map_50:.4f}")
print(f"AR@100:     {ar_100:.4f}")