from ultralytics import YOLO

project_name = "forestpersons"  # Define the project name for training results

model_type_list = [
    "yolov11n",
]

device = [4, 5]

for model_type in model_type_list:
    print(f"Training model: {model_type}")
    # model = YOLO(f"{model_type}.yaml")  # Load a pretrained YOLO model
    model = YOLO()  # Load a pretrained YOLO model

    results = model.train(
        project=project_name,  # Set the project name for saving results
        name=model_type,
        device=device,  # Specify the device(s) for training
        data="data_0924/forestpersons.yaml",
        verbose=True)  # Train the model on the specified dataset