#!/usr/bin/env python3
"""
YOLOv11 training script for ForestPersons Standing subset
"""
import os
os.environ['KMP_DUPLICATE_LIB_OK'] = 'TRUE'
os.environ['MKL_THREADING_LAYER'] = 'GNU'

from ultralytics import YOLO

def train_standing_model():
    """Train YOLOv11 on ForestPersons Standing subset"""
    
    project_name = "forestpersons_standing_0924"  # Project name for standing training results
    
    model_type_list = [
        "yolov11n",
        # "yolov11s",  # Uncomment for larger models
        # "yolov11m",
        # "yolov11l",
    ]
    
    # device = [5, 6]  # GPU devices to use
    device = [3, 4]  # GPU devices to use
    
    for model_type in model_type_list:
        print(f"🚶 Training {model_type} on ForestPersons Standing subset...")
        
        # Load a pretrained YOLO model
        model = YOLO(f"{model_type}.pt")
        
        # Train the model with default hyperparameters
        results = model.train(
            project=project_name,  # Set the project name for saving results
            name=model_type,       # Run name within the project
            device=device,         # Specify the device(s) for training
            data="data_forestpersons_v3/forestpersons_standing.yaml",  # Path to Standing dataset config
        )
        
        print(f"✅ Completed training {model_type} on Standing subset")
        print(f"📊 Results saved in: runs/{project_name}/{model_type}/")
        print("-" * 50)

if __name__ == "__main__":
    print("=" * 60)
    print("🚶 STARTING FORESTPERSONS STANDING TRAINING")
    print("=" * 60)
    
    train_standing_model()
    
    print("\n" + "=" * 60)
    print("🎉 STANDING TRAINING COMPLETED!")
    print("=" * 60)