#!/bin/bash

# YOLOv11 ForestPersons Standing Training Script
# Usage: bash train_standing.sh

echo "============================================================"
echo "🌞 STARTING YOLOV11 FORESTPERSONS STANDING TRAINING"
echo "============================================================"

# Check if CUDA is available
if command -v nvidia-smi &> /dev/null; then
    echo "🖥️  GPU Status:"
    nvidia-smi --query-gpu=index,name,memory.used,memory.total --format=csv,noheader,nounits | head -4
    echo ""
fi

# Start training
echo "🚀 Launching standing training..."
# python train_standing.py
python train_standing_0924.py

echo ""
echo "============================================================"
echo "✅ STANDING TRAINING COMPLETED!"
echo "📊 Check results in: runs/forestpersons_standing/"
echo "============================================================"