#!/usr/bin/env python3
"""
YOLOv11 training script for ForestPersons Summer subset
"""

from ultralytics import YOLO

def train_summer_model():
    """Train YOLOv11 on ForestPersons Summer subset"""
    
    project_name = "forestpersons_summer"  # Project name for summer training results
    
    model_type_list = [
        "yolov11n",
        # "yolov11s",  # Uncomment for larger models
        # "yolov11m",
        # "yolov11l",
    ]
    
    device = [5, 6]  # GPU devices to use
    
    for model_type in model_type_list:
        print(f"🌞 Training {model_type} on ForestPersons Summer subset...")
        
        # Load a pretrained YOLO model
        model = YOLO(f"{model_type}.pt")
        
        # Train the model with default hyperparameters
        results = model.train(
            project=project_name,  # Set the project name for saving results
            name=model_type,       # Run name within the project
            device=device,         # Specify the device(s) for training
            data="data/forestpersons_summer.yaml",  # Path to Summer dataset config
        )
        
        print(f"✅ Completed training {model_type} on Summer subset")
        print(f"📊 Results saved in: runs/{project_name}/{model_type}/")
        print("-" * 50)

if __name__ == "__main__":
    print("=" * 60)
    print("🌞 STARTING FORESTPERSONS SUMMER TRAINING")
    print("=" * 60)
    
    train_summer_model()
    
    print("\n" + "=" * 60)
    print("🎉 SUMMER TRAINING COMPLETED!")
    print("=" * 60)