#!/bin/bash

# YOLOv11 ForestPersons Summer Training Script
# Usage: bash train_summer.sh

echo "============================================================"
echo "🌞 STARTING YOLOV11 FORESTPERSONS SUMMER TRAINING"
echo "============================================================"

# Check if CUDA is available
if command -v nvidia-smi &> /dev/null; then
    echo "🖥️  GPU Status:"
    nvidia-smi --query-gpu=index,name,memory.used,memory.total --format=csv,noheader,nounits | head -4
    echo ""
fi

# Start training
echo "🚀 Launching summer training..."
# python train_summer.py
python train_summer_0924.py

echo ""
echo "============================================================"
echo "✅ SUMMER TRAINING COMPLETED!"
echo "📊 Check results in: runs/forestpersons_summer/"
echo "============================================================"