#!/bin/bash

# YOLOv11 ForestPersons Winter Training Script  
# Usage: bash train_winter.sh

echo "============================================================"
echo "❄️  STARTING YOLOV11 FORESTPERSONS WINTER TRAINING"
echo "============================================================"

# Check if CUDA is available
if command -v nvidia-smi &> /dev/null; then
    echo "🖥️  GPU Status:"
    nvidia-smi --query-gpu=index,name,memory.used,memory.total --format=csv,noheader,nounits | head -4
    echo ""
fi

# Start training
echo "🚀 Launching winter training..."
python train_winter.py

echo ""
echo "============================================================"
echo "✅ WINTER TRAINING COMPLETED!"
echo "📊 Check results in: runs/forestpersons_winter/"
echo "============================================================"