#!/bin/bash
#$ -S /bin/bash
#$ -cwd
#$ -j y
#$ -jc gpu-container_g1
#$ -ac d=nvcr-pytorch-2310

. /fefs/opt/dgx/env_set/nvcr-pytorch-2310-py3.sh

export PATH="xxx”
export LD_LIBRARY_PATH="xxx"
export LDFLAGS=-L/usr/local/nvidia/lib64
export PYTHONPATH="xxx"
export PYTHONUSERBASE="xxx"
export PREFIX="xxx"

export MY_PROXY_URL="http://10.1.10.1:8080/"
export HTTP_PROXY=$MY_PROXY_URL
export HTTPS_PROXY=$MY_PROXY_URL
export FTP_PROXY=$MY_PROXY_URL
export http_proxy=$MY_PROXY_URL
export https_proxy=$MY_PROXY_URL
export ftp_proxy=$MY_PROXY_URL

export TRANSFORMERS_CACHE="/home/xxx"
export HF_DATASETS_CACHE="/home/xxx"

pip install datasets pandas
python dataset_generate.py --output_path "../../dataset" --task_name mnli --k_shot 500 --val_split=0.1 --benchmark='glue'
python dataset_generate.py --output_path "../../dataset" --task_name qqp --k_shot 500 --val_split=0.1 --benchmark='glue'
python dataset_generate.py --output_path "../../dataset" --task_name sst2 --k_shot 500 --val_split=0.1 --benchmark='glue'
python dataset_generate.py --output_path "../../dataset" --task_name mrpc --k_shot 500 --val_split=0.1 --benchmark='glue'
python dataset_generate.py --output_path "../../dataset" --task_name cola --k_shot 500 --val_split=0.1 --benchmark='glue'
python dataset_generate.py --output_path "../../dataset" --task_name wnli --k_shot 500 --val_split=0.1 --benchmark='glue'
python dataset_generate.py --output_path "../../dataset" --task_name qnli --k_shot 500 --val_split=0.1 --benchmark='glue'
python dataset_generate.py --output_path "../../dataset" --task_name rte --k_shot 500 --val_split=0.1 --benchmark='glue'
python dataset_generate.py --output_path "../../dataset" --task_name CI --k_shot 500 --val_split=0.1
python dataset_generate.py --output_path "../../dataset" --task_name SE --k_shot 500 --val_split=0.1
python dataset_generate.py --output_path "../../dataset" --task_name RCT --k_shot 500 --val_split=0.1
python dataset_generate.py --output_path "../../dataset" --task_name HP --k_shot 500 --val_split=0.1
python dataset_generate.py --output_path "../../dataset" --task_name imdb --k_shot 500 --val_split=0.1