# UOE: UNLEARNING ONE EXPERT IS ENOUGH FOR MIXTURE-OF-EXPERTS LLMS

## Abstract

Recent advancements in large language model (LLM) unlearning have shown remarkable success in removing unwanted data-model influences while preserving the model's utility for legitimate knowledge. However, despite these strides, sparse Mixture-of-Experts (MoE) LLMs--a key subset of the LLM family--have received little attention and remain largely unexplored in the context of unlearning. As MoE LLMs are celebrated for their exceptional performance and highly efficient inference processes, we ask: How can unlearning be performed effectively and efficiently on MoE LLMs? And will traditional unlearning methods be applicable to MoE architectures? Our pilot study shows that the dynamic routing nature of MoE LLMs introduces unique challenges, leading to substantial utility drops when existing unlearning methods are applied. Specifically, unlearning disrupts the router's expert selection, causing significant selection shift from the most unlearning target-related experts to irrelevant ones. As a result, more experts than necessary are affected, leading to excessive forgetting and loss of control over which knowledge is erased. To address this, we propose a novel single-expert unlearning framework, referred to as UOE, for MoE LLMs. Through expert attribution, unlearning is concentrated on the most actively engaged expert for the specified knowledge. Concurrently, an anchor loss is applied to the router to stabilize the active state of this targeted expert, ensuring focused and controlled unlearning that preserves model utility. The proposed UOE framework is also compatible with various unlearning algorithms. Extensive experiments demonstrate that UOE enhances both forget quality up to 5% and model utility by 35% on MoE LLMs across various benchmarks, LLM architectures, while only unlearning 0.06% of the model parameters.

## Requirement

Please refer to [LLama-Factory](https://github.com/hiyouga/LLaMA-Factory) to set up environment.

## Quick Start

Conduct experiment on unlearning DeepSeek using GA+UOE with the following code:

```
llamafactory-cli train examples\Deepseek_WMDP\GA_layer16.yaml
```

## Evaluation

[RWKU Github](https://github.com/jinzhuoran/RWKU) provides code for evaluating RWKU Benchmark results.

[lm-eval Github](https://github.com/EleutherAI/lm-evaluation-harness) provides evaluation for MMLU and WMDP.
