# f-MICL: Understanding and Generalizing InfoNCE-based Contrastive Learning

* Requirement: pytorch1.4, cuda10.1, python3.6, torchvision0.5.0, tqdm, pandas, wandb

* Install packages: ``pip install torch==1.4.0 torchvision==0.5.0 tqdm pandas wandb``

## Running on vision datasets: CIFAR10/CIFAR100/STL10/Tiny-ImageNet/ImageNet

For the first three datasets, the main script will download the datasets automatically. Tiny-imagenet requires downloading the dataset. We recommend using the recipe in https://gist.github.com/moskomule/2e6a9a463f50447beca4e64ab4699ac4 for downloading, unzipping and setting up the validation set. 
Go to the folder "gaussian_kernel" and simly run each file using python command to run, for example:

```python

$ python gaussian_kernel_cifar10.py --estimator='Gaussian-KL' --epoch=200

```
the scripts automatically run testing for every epoch using KNN predictor, if you wish to use linear evaluation instead, simply run the linear_evaluation.py file with your pretrained model.

For imagenet we use multi-gpu training and requires downloading the dataset from https://image-net.org/, an example of running experiments on ImageNet:

```python

$ python gaussian_kernel_imagenet.py
  -a resnet50 \
  --lr 0.03 \
  --batch-size 256 \
  --estimator 'Gaussian-KL'\
  --resume 'checkpoint.pth.tar'\
  --dist-url 'tcp://localhost:10001' --multiprocessing-distributed --world-size 1 --rank 0 \
  'your imagenet train folder'

```

## Ablation studies

additionaly, we provide scripts for running cosine kernels on CIFAR10, go to the folder "cosine_kernel" and run the file using python command, for example:

```python

$ python cos_kernel_cifar10.py --estimator='Gaussian-KL' --epoch=200

```

## Language task

for language task, we use the code from https://github.com/princeton-nlp/SimCSE and change only the /simcse/models.py file. We put our model file in the folder "language". Simply set up everything according to the instructions in https://github.com/princeton-nlp/SimCSE and  replace our model with that in SimCSE and run the file using bash command, for example:

```bash

$ bash run_unsup_example.sh
```
