#!/bin/bash
#SBATCH --array=0
#SBATCH --mem=40GB
#SBATCH --output=%j.out
#SBATCH --error=%j.err
#SBATCH --qos=edok
#SBATCH --gres=gpu:1
#SBATCH -A edok
#SBATCH -c 4
#SBATCH --partition=edok

EROOT="/h/$1/governance-games"
RROOT="/data/u/$2/gg"

poetry run python $EROOT/main.py \
    --experiment_name "adult_two_datasets" \
    --prev_results_dir $EROOT/previous_results/ \
    --save_path $EROOT/results/ \
    --path $RROOT/ \
    --data_dir /data/datasets/ \
    --num_rounds 20 \
    --init_priv 2 \
    --init_fair 0.2 \
    --dataset 'adult' 'credit-card' \
    --priority 'regulator' \
    --step_size_priv 100 \
    --step_size_fair 10 \
    --lambda_priv 0.1 \
    --lambda_fair 1 \
    --C_priv 1 \
    --C_fair 1 \
    --goal_priv 7 \
    --goal_fair 0.05 \
    --calibration 1 \