#!/bin/bash
#SBATCH --array=0
#SBATCH --mem=40GB
#SBATCH --output=%j.out
#SBATCH --error=%j.err
#SBATCH --qos=edok
#SBATCH --gres=gpu:1
#SBATCH -A edok
#SBATCH -c 4
#SBATCH --partition=edok

EROOT="/h/$1/governance-games"
RROOT="/data/u/$2/gg"

#priv_values=(1 1.5 2 2.5 3 3.5)
#fair_values=(0.06 0.1 0.15)
priv_values=(1 1.5 2 2.5 3 3.5 4 4.5 5 5.5)
fair_values=(0.03 0.06 0.1 0.15 0.2 0.22)

for priv in "${priv_values[@]}"; do
    for fair in "${fair_values[@]}"; do
        # Adjust experiment name to include priv, fair values and priority
        experiment_name="adult_two_datasets_many/${priv}_${fair}"
        init_priv_val=$priv
        init_fair_val=$fair

        goal_priv_val=$priv
        goal_fair_val=$fair

        # Run the command with the specified parameters
        poetry run python $EROOT/main.py \
            --experiment_name "$experiment_name" \
            --prev_results_dir $EROOT/previous_results/ \
            --save_path $EROOT/results/ \
            --path $RROOT/ \
            --data_dir /data/datasets/ \
            --num_rounds 20 \
            --init_priv $init_priv_val \
            --init_fair $init_fair_val \
            --dataset 'adult' 'credit-card' \
            --priority "regulator" \
            --step_size_priv 100 \
            --step_size_fair 10 \
            --lambda_priv 0.1 \
            --lambda_fair 1 \
            --C_priv 1 \
            --C_fair 1 \
            --goal_priv $goal_priv_val \
            --goal_fair $goal_fair_val \
            --calibration 1
    done
done
