#!/bin/bash
#SBATCH --array=0
#SBATCH --mem=40GB
#SBATCH --output=%j.out
#SBATCH --error=%j.err
#SBATCH --qos=edok
#SBATCH --gres=gpu:1
#SBATCH -A edok
#SBATCH -c 4
#SBATCH --partition=edok

EROOT="/h/$1/governance-games"
RROOT="/data/u/$2/gg"

#priv_values=(1 1.5 2 2.5 3 3.5)
#fair_values=(0.06 0.1 0.15)
priv_values=(2 2.5 3 3.5 4 4.5 5 5.5)
fair_values=(0.06 0.1 0.15 0.2 0.22)
priorities=("builder" "regulator")
# Predefined high values for builder led
high_priv=4
high_fair=0.7

for priv in "${priv_values[@]}"; do
    for fair in "${fair_values[@]}"; do
        for priority in "${priorities[@]}"; do
            # Adjust experiment name to include priv, fair values and priority
            if [ "$priority" == "builder" ]; then
                experiment_name="credit-card_FM_builder_led_$3/${priv}_${fair}"
                init_priv_val=$high_priv
                init_fair_val=$high_fair 
            else
                experiment_name="credit-card_FM_regulator_led_$3/${priv}_${fair}"
                init_priv_val=$priv
                init_fair_val=$fair
            fi

            goal_priv_val=$priv  # Set to the loop priv for builder led
            goal_fair_val=$fair  # Set to the loop fair for builder led

            # --lambda_priv 0.000012426808624157545 \
            #     --lambda_fair 0.00818097258310479 \

            # Run the command with the specified parameters
            poetry run python $EROOT/main.py \
                --experiment_name "$experiment_name" \
                --prev_results_dir $EROOT/previous_results/ \
                --save_path $EROOT/results/ \
                --path $RROOT/ \
                --data_dir /data/datasets/ \
                --num_rounds 20 \
                --init_priv $init_priv_val \
                --init_fair $init_fair_val \
                --dataset 'credit-card' \
                --priority "$priority" \
                --step_size_priv 300 \
                --step_size_fair 30 \
                --step_size_decay 1.5 \
                --builder_lambda 0.7 \
                --lambda_priv 0.001 \
                --lambda_fair 0.03 \
                --C_priv 2.1819329229772406 \
                --C_fair 0.9960756191601947 \
                --goal_priv $goal_priv_val \
                --goal_fair $goal_fair_val \
                --calibration 1 \
                --init_as_goal 0
        done
    done
done
