# For loop over dataset, fairness metric and seeds

seeds=(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15)
budgets=(3 9)
fairness_metrics=(DemParity)
datasets=(adult)
pate_based_models=(pateSpre pateSin)

num_cores=8

process_data() {
    fairness_metric="$1"
    dataset="$2"
    budget="$3"
    seed="$4"
    pate_based_model="$5"

    PYTHONPATH="." python ./fairpate_tabular/fairpate.py --dataset $dataset --budget $budget --seed $seed --fairness_metric $fairness_metric --use_optuna --num_optuna_trials 100 --pate_based_model $pate_based_model --verbose
}

export -f process_data
parallel --linebuffer -j $num_cores process_data ::: "${fairness_metrics[@]}" ::: "${datasets[@]}" ::: "${budgets[@]}" ::: "${seeds[@]}" ::: "${pate_based_models[@]}"
