# For loop over dataset, fairness metric and seeds

seeds=(1 2 3 4 5)
budgets=(3 9 10000)
fairness_metrics=(DemParity)
datasets=(adult)
fairness_thresholds=(0 0.01 0.05 0.1 0.2 0.3 0.4 0.5)
num_cores=8


process_data() {
    fairness_metric="$1"
    dataset="$2"
    budget="$3"
    seed="$4"
    fairness_threshold="$5"

    PYTHONPATH="." python ./fairpate_tabular/fairpate.py --dataset $dataset --budget $budget --seed $seed --fairness_metric $fairness_metric --use_optuna --num_optuna_trials 100 --use_inference_time_postprocessing --fairness_threshold $fairness_threshold --verbose 
}

export -f process_data
parallel --linebuffer -j $num_cores process_data ::: "${fairness_metrics[@]}" ::: "${datasets[@]}" ::: "${budgets[@]}" ::: "${seeds[@]}" ::: "${fairness_thresholds[@]}"
