# For loop over dataset, fairness metric and seeds

seeds=(1 2 3 4 5)
budgets=(1 3 9 10000)
fairness_metrics=(DemParity)
datasets=(adult)
fairness_thresholds=(0 0.01 0.05 0.1 0.2)
num_cores=8


process_data_without_IPP() {
    fairness_metric="$1"
    dataset="$2"
    budget="$3"
    seed="$4"
    fairness_threshold="$5"

    PYTHONPATH="." python ./fairpate_tabular/fairpate.py --dataset $dataset --budget $budget --seed $seed --fairness_metric $fairness_metric --fairness_threshold $fairness_threshold --use_optuna --optuna_db_path "./IPP_undersampled_1.0_stratified" --num_optuna_trials 100 --verbose --undersampling_ratio 1.0 --use_stratification
}

process_data_with_IPP() {
    fairness_metric="$1"
    dataset="$2"
    budget="$3"
    seed="$4"
    fairness_threshold="$5"

    PYTHONPATH="." python ./fairpate_tabular/fairpate.py --dataset $dataset --budget $budget --seed $seed --fairness_metric $fairness_metric --fairness_threshold $fairness_threshold --use_optuna --optuna_db_path "./IPP_undersampled_1.0_stratified" --num_optuna_trials 100 --use_inference_time_postprocessing  --verbose --undersampling_ratio 1.0 --use_stratification
}



export -f process_data_without_IPP
parallel --linebuffer -j $num_cores process_data_without_IPP ::: "${fairness_metrics[@]}" ::: "${datasets[@]}" ::: "${budgets[@]}" ::: "${seeds[@]}" ::: "${fairness_thresholds[@]}"

export -f process_data_with_IPP
parallel --linebuffer -j $num_cores process_data_with_IPP ::: "${fairness_metrics[@]}" ::: "${datasets[@]}" ::: "${budgets[@]}" ::: "${seeds[@]}" ::: "${fairness_thresholds[@]}"