seeds=(1 2 3 4 5 6 7 8 9 10)
budgets=(0.5 1 3 9 10000)
fairness_metrics=(DemParity)
datasets=(parkinsons)

num_cores=8

process_data() {
    fairness_metric="$1"
    dataset="$2"
    budget="$3"
    seed="$4"

    PYTHONPATH="." python ./fairpate_tabular/fairpate.py --dataset $dataset --budget $budget --seed $seed --fairness_metric $fairness_metric --use_optuna --num_optuna_trials 100 --verbose
}

export -f process_data
parallel --linebuffer -j $num_cores process_data ::: "${fairness_metrics[@]}" ::: "${datasets[@]}" ::: "${budgets[@]}" ::: "${seeds[@]}"