# Sparse-VNN

This repository contains the code for the paper "Sparse Covariance Neural Networks". The code for VNN is taken from https://github.com/sihags/VNN.

### Usage

Example of run

```
python main_vnn_brain.py --dimNodeSignals 1,32,32 --dimLayersMLP 32,16,1 --sparse_tensor true --cov_type RCV --p 0.25 --dset epilepsy --nEpochs 50
```

Parameters:
- `dimNodeSignals`: the size of each layer of VNN (as a csv string)
- `dimLayersMLP`: the size of the MLP layers for the final task (as a csv string)
- `sparse_tensor`: if `True`, use torch.sparse to represent the covariance matrix, otherwise, store it as a dense matrix
- `cov_type`: type of covariance sparsification used for the experiment. Supports `standard` (no sparsification), `RCV` (with additional parameter `p`), `ACV`, `hard_thr` and `soft_thr`.
- `dset`: dataset. Supports `SparseCov`, `LargeCov`, `SmallCov`
- `tau`: parameter for thresholding
- `lr`: learning rate
- `iterations`: how many times to repeat an experiment
- `batchSize`: batch size
- `nEpochs`: number of epochs


### Data availability

- The synthetic datasets `SparseCov`, `LargeCov` and `SmallCov` are available in the `Data` folder.
- `Realdisp` can be downloaded at https://archive.ics.uci.edu/dataset/305/realdisp+activity+recognition+dataset and preprocessed with functions in `utils.py`
- `MHEALTH` can be downloaded at https://archive.ics.uci.edu/dataset/319/mhealth+dataset and preprocessed with functions in `utils.py` 
- `CNI` can be downloaded at http://www.brainconnectivity.net/challenge.html and preprocessed with functions in `utils.py` 
- `epilepsy` can be downloaded at https://math.bu.edu/people/kolaczyk/datasets.html. We provide the preprocessed version in the `Data` folder.

### Repository structure

- `Data`: folder containing the datasets
- `Modules`: folder containing model definitions 
- `out`: folder for saving results
- `Utils`: folder with various utility functions
- `main_vnn_sparse.py`: run stability experiments on synthetic data with hard and soft thresholding. Supports `hard_thr` and `soft_thr` for sparsification and synthetic datasets.
- `main_vnn_prob.py`: run stability experiments on synthetic data with stochastic sparsification (both ACV and RCV). 
- `main_vnn_har.py`: run experiments on Human Action Recognition datasets. Supports `mhealth` and `realdisp`.
- `main_vnn_brain.py`: run experiments on brain datasets. Supports `epilepsy` and `cni`.
- `utils.py`: additional utility functions

### Requirements

- Python 3.11.5
- `pip install -r requirements.txt`
