import argparse

def parse_args():
    parser = argparse.ArgumentParser(description='training args.')

    # prompt args
    parser.add_argument('--task', type=str)
    parser.add_argument('--seed', type=int)
    parser.add_argument('--batch-size',
                        type=int,
                        default=16,
                        help='batchsize in decoding. Left padding in default')
    parser.add_argument('--max-new-tokens',
                        type=int,
                        default=128,
                        help='max new tokens to generate by the model')
    parser.add_argument('--output',
                        type=str,
                        default=None,
                        help='output file name')

    parser.add_argument(
        '--sample_num',
        type=int,
        default=100,
        help='number of samples used to choose the optimized sequences')

    # DE args
    parser.add_argument('--budget', type=int, default=10)
    parser.add_argument('--num_of_manual',
                        type=int,
                        default=5,
                        help='number of manually written prompts')
    parser.add_argument('--popsize', type=int, default=10)
    parser.add_argument('--evo_mode', type=str, default='de', help='mode of the evolution', choices=['de','ga'])
    parser.add_argument('--donor_random',action='store_true',help='for DE, whether to use random donor or the best one as the Prompt 3')
    parser.add_argument('--sel_mode', type=str, choices=['wheel', 'random', 'tour'], default='wheel')

    parser.add_argument('--llm_type', type=str, default='davinci')
    parser.add_argument('--initial', type=str, default='manual', choices=['ape', 'manual', 'all', 'ckpt'])
    parser.add_argument('--initial_mode', type=str)
    parser.add_argument('--ratio', type=float, default=0)
    parser.add_argument('--para_mode', type=str, default=None)
    parser.add_argument('--template', type=str, default='v1')
    parser.add_argument('--client', action='store_true'),

    parser.add_argument('--cache_path', type=str, default=None)
    parser.add_argument('--setting', type=str, default=None)
    parser.add_argument('--ga_mode', type=str, default='topk')
    parser.add_argument('--content', type=str, default='', help='content of the prompt, use for evaluation')
    parser.add_argument('--ckpt_pop', type=str, default=None, help='path to the ckpt population')
    parser.add_argument('--consis', action='store_true')
    parser.add_argument('--demon', type=int, default=1, help='few-shot if 1, zero-shot if 0')
    parser.add_argument('--client_host', type=str, default=None, help='davinci client account name')
    args = parser.parse_args()
    return args