import os

from evolution import evolution
from utils import  set_seed
from args import parse_args
from llm_client import llm_init, LLMClient


if __name__ == "__main__":
    args = parse_args()
    set_seed(args.seed)
    if args.client:
        client = LLMClient(args.client_host)
        llm_config = {}
    else:
        client = None
        llm_config = llm_init(f"./auth.yaml", args.llm_type, args.setting)
    if args.evo_mode == 'de':
        evolution(args, llm_config, client)
    elif args.evo_mode == 'ga':
        from evoluter import GAEvoluter
        evoluter = GAEvoluter(args, llm_config, client)
        evoluter.evolute()

