#!/bin/bash

set -ex


BUDGET=10
POPSIZE=10
NUM_OF_MANUAL=10
template=v9
llm=davinci
initial=all
initial_mode=para_topk

for task in temporal_sequences disambiguation_qa tracking_shuffled_objects_three_objects penguins_in_a_table geometric_shapes snarks ruin_names tracking_shuffled_objects_seven_objects tracking_shuffled_objects_five_objects logical_deduction_three_objects hyperbaton logical_deduction_five_objects logical_deduction_seven_objects movie_recommendation salient_translation_error_detection reasoning_about_colored_objec
do
for SIZE in 10
do
POPSIZE=$SIZE
NUM_OF_MANUAL=$SIZE
OUT_PATH=outputs/$task/$initial/de/bd${BUDGET}_top${NUM_OF_MANUAL}_${initial_mode}_init/$template/$llm
for seed in 10
do
mkdir -p $OUT_PATH/seed${seed}
cache_path=cache/$task/seed$seed
mkdir -p $cache_path
python run.py \
    --seed $seed \
    --task $task \
    --batch-size 20 \
    --sample_num 50 \
    --budget $BUDGET \
    --popsize $POPSIZE \
    --num_of_manual $NUM_OF_MANUAL \
    --evo_mode de \
    --llm_type $llm \
    --setting gcr \
    --initial $initial \
    --initial_mode $initial_mode \
    --client \
    --template $template \
    --cache_path $cache_path/prompts_$llm.json \
    --output $OUT_PATH/seed${seed}
done
done
done